<?php

namespace Import\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * InterestRateFPAndFGSP
 *
 * @ORM\Table(name="interest_rate_fp_fgsp")
 * @ORM\Entity(repositoryClass="Import\ApiBundle\Repository\InterestRateFPAndFGSPRepository")
 */
class InterestRateFPAndFGSP
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="monthFrom", type="integer")
     */
    private $monthFrom;

    /**
     * @var integer
     *
     * @ORM\Column(name="yearFrom", type="integer")
     */
    private $yearFrom;

    /**
     * @var integer
     *
     * @ORM\Column(name="monthTo", type="integer")
     */
    private $monthTo;

    /**
     * @var integer
     *
     * @ORM\Column(name="yearTo", type="integer")
     */
    private $yearTo;

    /**
     * @var float
     *
     * @ORM\Column(name="interestRateFP", type="float")
     */
    private $interestRateFP;

    /**
     * @var float
     *
     * @ORM\Column(name="interestRateFGSP", type="float")
     */
    private $interestRateFGSP;

    /**
     * @var string $description
     *
     * @ORM\Column(name="description", type="string", length=255)
     */
    private $description;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set monthFrom
     *
     * @param integer $monthFrom
     * @return InterestRateFPAndFGSP
     */
    public function setMonthFrom($monthFrom)
    {
        $this->monthFrom = $monthFrom;
    
        return $this;
    }

    /**
     * Get monthFrom
     *
     * @return integer 
     */
    public function getMonthFrom()
    {
        return $this->monthFrom;
    }

    /**
     * Set yearFrom
     *
     * @param integer $yearFrom
     * @return InterestRateFPAndFGSP
     */
    public function setYearFrom($yearFrom)
    {
        $this->yearFrom = $yearFrom;
    
        return $this;
    }

    /**
     * Get yearFrom
     *
     * @return integer 
     */
    public function getYearFrom()
    {
        return $this->yearFrom;
    }

    /**
     * Set monthTo
     *
     * @param integer $monthTo
     * @return InterestRateFPAndFGSP
     */
    public function setMonthTo($monthTo)
    {
        $this->monthTo = $monthTo;
    
        return $this;
    }

    /**
     * Get monthTo
     *
     * @return integer 
     */
    public function getMonthTo()
    {
        return $this->monthTo;
    }

    /**
     * Set yearTo
     *
     * @param integer $yearTo
     * @return InterestRateFPAndFGSP
     */
    public function setYearTo($yearTo)
    {
        $this->yearTo = $yearTo;
    
        return $this;
    }

    /**
     * Get yearTo
     *
     * @return integer 
     */
    public function getYearTo()
    {
        return $this->yearTo;
    }

    /**
     * Set interestRateFP
     *
     * @param float $interestRateFP
     * @return InterestRateFPAndFGSP
     */
    public function setInterestRateFP($interestRateFP)
    {
        $this->interestRateFP = $interestRateFP;
    
        return $this;
    }

    /**
     * Get interestRateFP
     *
     * @return float 
     */
    public function getInterestRateFP()
    {
        return $this->interestRateFP;
    }

    /**
     * Set interestRateFGSP
     *
     * @param float $interestRateFGSP
     * @return InterestRateFPAndFGSP
     */
    public function setInterestRateFGSP($interestRateFGSP)
    {
        $this->interestRateFGSP = $interestRateFGSP;
    
        return $this;
    }

    /**
     * Get interestRateFGSP
     *
     * @return float 
     */
    public function getInterestRateFGSP()
    {
        return $this->interestRateFGSP;
    }

    /**
     * Set description
     *
     * @param string $description
     * @return InterestRateFPAndFGSP
     */
    public function setDescription($description)
    {
        $this->description = $description;
    
        return $this;
    }

    /**
     * Get description
     *
     * @return string 
     */
    public function getDescription()
    {
        return $this->description;
    }
}